<?php
/*
очистка таблицы хитов по крону.
в crontab поставить команду вида:
0 1 * * * /usr/bin/php -q /home/user/antibot.cloud/antibot/code/clear_old_hits.php > /dev/null 2>&1
суть которой: 
0 1 * * * - это значит запускать в час ночи каждый день.
/home/user/antibot.cloud/antibot/code/clear_old_hits.php путь к этому скрипту относительно корня сервера.

lastday - удалять старше суток
lastweek - удалять старше недели
lastmonth - - удалять старше месяца
lastyear - удалить старше года
all - удалить все логи
*/

require_once(__DIR__.'/../data/conf.php');

if (php_sapi_name() != 'cli') die('no cli');

$lastlog = 'Cron start time: '.date('Y.m.d H:i:s', time())."\n";
clearstatcache();
$startsize = filesize(__DIR__.'/../data/sqlite.db');
$lastlog .= 'Start DB size: '.round($startsize / 1024 / 1024, 2).' MiB'."\n";

$antibot_db = new SQLite3(__DIR__.'/../data/sqlite.db'); 
$antibot_db->busyTimeout(5000);
$antibot_db->exec("PRAGMA journal_mode = WAL;");

$ab_config['period_cleaning'] = isset($ab_config['period_cleaning']) ? $ab_config['period_cleaning'] : 'lastmonth';

// искать до указанной даты
$tl['lastday'] = time() - 86400; // сутки
$tl['lastweek'] = time() - (86400*7); // неделя
$tl['lastmonth'] = time() - (86400*30); // месяц
$tl['lastyear'] = time() - (86400*365); // год

if (isset($tl[$ab_config['period_cleaning']])) {
$datelimit = 'WHERE date < \''.$tl[$ab_config['period_cleaning']].'\'';
} else {
$datelimit = '';
}

$del = $antibot_db->exec("DELETE FROM hits ".$datelimit.";");
$deleted = (int) $antibot_db->changes(); // кол-во строк удалено
$vacuum = $antibot_db->exec("VACUUM;");
$antibot_db->close();

clearstatcache();
$finalsize = filesize(__DIR__.'/../data/sqlite.db');
$lastlog .= 'Final DB size: '.round($finalsize / 1024 / 1024, 2).' MiB'."\n";
$lastlog .= 'Entries removed: '.$deleted."\n";
$lastlog .= 'Cron end time: '.date('Y.m.d H:i:s', time())."\n";
$lastlog .= 'Period: '.$ab_config['period_cleaning']."\n";
file_put_contents(__DIR__.'/../data/cronlog', $lastlog, LOCK_EX);
echo "ok\n";
