<?php
// список правил
if(!defined('ANTIBOT')) die('access denied');

$title = abTranslate('Blocking and Permission Rules');

$del = $antibot_db->exec("DELETE FROM ipv4rules WHERE expires < ".$ab_config['time'].";");
$del = $antibot_db->exec("DELETE FROM ipv6rules WHERE expires < ".$ab_config['time'].";");
$del = $antibot_db->exec("DELETE FROM rules WHERE expires < ".$ab_config['time'].";");

$rules = $antibot_db->query("SELECT rowid, * FROM rules ORDER BY priority ASC;"); 
$ipv4rules = $antibot_db->query("SELECT rowid, * FROM ipv4rules ORDER BY priority ASC;"); 
$ipv6rules = $antibot_db->query("SELECT rowid, * FROM ipv6rules ORDER BY priority ASC;"); 
$ab_se_rules = $antibot_db->query("SELECT rowid, * FROM ab_se ORDER BY priority ASC;"); 
$ab_se_path = $antibot_db->query("SELECT rowid, * FROM ab_path ORDER BY priority ASC;"); 

$content .= '
<p>'.abTranslate('The order in which the rules are processed is in the order of these tables and priorities.').' '.abTranslate('The check goes up to the first <span style="color:green;">ALLOW</span> (allow access to the website without showing the antibot check) or until the first <span style="color:red;">BLOCK</span> (blocking with displaying the page content from the error.txt template). If <span style="color:gray;">GRAY</span> is encountered, then the validation cycle continues according to all the rules, but at the end on the validation JS page (template tpl.txt) there will be no automatic passage and the visitor will have to press the login buttons.').'</p>
<p>
<ol>
<li><a href="#ipv4rules_0">'.abTranslate('Table of IPv4 rules.').'</a></li>
<li><a href="#ipv6rules_0">'.abTranslate('Table of IPv6 rules.').'</a></li>
<li><a href="#ab_se_0">'.abTranslate('Search by User-Agent part.').'</a></li>
<li><a href="#ab_path_0">'.abTranslate('Search by URL part.').'</a></li>
<li><a href="#rules_0">'.abTranslate('General rules for various parameters.').'</a></li>
</ol>
</p>
<div class="table-responsive">
<table class="table table-bordered table-hover table-sm">
<thead class="thead-light">
<tr><th colspan="6"><a name="ipv4rules_0"></a> '.abTranslate('1) IPv4 or IPv6 is checked first, in order of priority. In the request log, successful requests (allow) have the status <strong><span style="color:blue;">GOODIP</span></strong>. The IP addresses of search engines added to the rules of table # 3 are automatically added to these rules.').'</th></tr>
<tr>
<th>priority</th>
<th>rule</th>
<th>search IPv4</th>
<th>comment</th>
<th>expires</th>
<th></th>
</tr>
</thead>
<tbody>
';
$i = 0;
while ($echo = $ipv4rules->fetchArray(SQLITE3_ASSOC)) {
$i++;
if ($echo['rule'] == 'allow') {$style = 'style="color:green;"';} elseif ($echo['rule'] == 'block') {$style = 'style="color:red;"';} else {$style = 'style="color:gray;"';}
$content .= '<tr>
<td><a name="ipv4rules_'.$echo['rowid'].'"></a><form action="?'.$abw.$abp.'=priority" method="post" class="form-inline">
<input name="id" type="hidden" value="'.$echo['rowid'].'">
<input name="table" type="hidden" value="ipv4rules">
<input class="form-control form-control-sm col-md-10" name="priority" type="text" value="'.$echo['priority'].'">
<button type="submit" name="priority_submit" class="btn btn-sm btn-primary col-md-2"><i class="bi bi-arrow-repeat"></i></button>
</form></td>
<td '.$style.'>'.$echo['rule'].'</td>
<td>'.((filter_var($echo['search'], FILTER_VALIDATE_IP) !== false) ? '<a href="?'.$abw.$abp.'=hits&search='.$echo['search'].'&table=ip&operator=equally">'.$echo['search'].'</a>' : $echo['search']).'</td>
<td><small>'.$echo['comment'].'</small></td>
<td><small>'.((is_numeric($echo['expires'])) ? date("Y.m.d H:i:s", $echo['expires']) : '').'</small></td>
<td><form action="?'.$abw.$abp.'=remove" method="post">
<input name="id" type="hidden" value="'.$echo['rowid'].'">
<input name="table" type="hidden" value="ipv4rules">
<button type="submit" name="remove_submit" class="btn btn-danger btn-sm" title="'.abTranslate('Remove').'">
<i class="bi bi-trash"></i>
</button>
</form></td>
</tr>';
}
$content .= '
<form action="?'.$abw.$abp.'=newrule" method="post">
<tr>
<td><input type="hidden" name="type" value="ipv4">
<input name="priority" type="text" class="form-control form-control-sm" id="priority" value="100">
<small class="text-muted">'.abTranslate('Priority (order) of checking and applying the rules.').'</small></td>
<td>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="allow1" value="allow" required>
  <label class="form-check-label" for="allow1" style="color:green;">ALLOW</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="block1" value="block">
  <label class="form-check-label" for="block1" style="color:red;">BLOCK</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="gray1" value="gray">
  <label class="form-check-label" for="gray1" style="color:gray;">GRAY</label>
</div></td>
<td>
	<input name="data" type="text" class="form-control form-control-sm" id="data" value="">
	<small class="text-muted">'.abTranslate('IPv4 like 123.123.123.123 or subnet 123.123.123.0/24').'</small></td>
<td>
      <input name="comment" type="text" class="form-control form-control-sm" id="comment" value="">
      <small class="text-muted">'.abTranslate('Description, so as not to forget why it was created.').'</small>
</td>
<td>
      <input name="expires" type="text" class="form-control form-control-sm" id="expires" value="">
      <small class="text-muted">'.abTranslate('Rule validity period in days, then it will be deleted, leave blank for permanent effect.').'</small>
</td>
<td><button type="submit" name="newrule_submit" class="btn btn-success btn-sm" title="'.abTranslate('Add').'"><i class="bi bi-plus-square"></i></button></td>
</tr>
</form>
<tr><td colspan="6" class="text-muted">'.abTranslate('Total rules:').' '.$i.'</td></tr></tbody>
</table>
</div>
<br />
';

$content .= '
<div class="table-responsive">
<table class="table table-bordered table-hover table-sm">
<thead class="thead-light">
<tr><th colspan="6"><a name="ipv6rules_0"></a> '.abTranslate('2) IPv4 or IPv6 is checked first, in order of priority. In the request log, successful requests (allow) have the status <strong><span style="color:blue;">GOODIP</span></strong>. The IP addresses of search engines added to the rules of table # 3 are automatically added to these rules.').'</th></tr>
<tr>
<th>priority</th>
<th>rule</th>
<th>search IPv6</th>
<th>comment</th>
<th>expires</th>
<th></th>
</tr>
</thead>
<tbody>
';
$i = 0;
while ($echo = $ipv6rules->fetchArray(SQLITE3_ASSOC)) {
$i++;
if ($echo['rule'] == 'allow') {$style = 'style="color:green;"';} elseif ($echo['rule'] == 'block') {$style = 'style="color:red;"';} else {$style = 'style="color:gray;"';}
$content .= '<tr>
<td><a name="ipv6rules_'.$echo['rowid'].'"></a><form action="?'.$abw.$abp.'=priority" method="post" class="form-inline">
<input name="id" type="hidden" value="'.$echo['rowid'].'">
<input name="table" type="hidden" value="ipv6rules">
<input class="form-control form-control-sm col-md-10" name="priority" type="text" value="'.$echo['priority'].'">
<button type="submit" name="priority_submit" class="btn btn-sm btn-primary col-md-2"><i class="bi bi-arrow-repeat"></i></button>
</form></td>
<td '.$style.'>'.$echo['rule'].'</td>
<td>'.((filter_var($echo['search'], FILTER_VALIDATE_IP) !== false) ? '<a href="?'.$abw.$abp.'=hits&search='.$echo['search'].'&table=ip&operator=equally">'.$echo['search'].'</a>' : $echo['search']).'</td>
<td><small>'.$echo['comment'].'</small></td>
<td><small>'.((is_numeric($echo['expires'])) ? date("Y.m.d H:i:s", $echo['expires']) : '').'</small></td>
<td><form action="?'.$abw.$abp.'=remove" method="post">
<input name="id" type="hidden" value="'.$echo['rowid'].'">
<input name="table" type="hidden" value="ipv6rules">
<button type="submit" name="remove_submit" class="btn btn-danger btn-sm" title="'.abTranslate('Remove').'">
<i class="bi bi-trash"></i>
</button>
</form></td>
</tr>';
}
$content .= '
<form action="?'.$abw.$abp.'=newrule" method="post">
<tr>
<td><input type="hidden" name="type" value="ipv6">
<input name="priority" type="text" class="form-control form-control-sm" id="priority" value="100">
<small class="text-muted">'.abTranslate('Priority (order) of checking and applying the rules.').'</small></td>
<td>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="allow2" value="allow" required>
  <label class="form-check-label" for="allow2" style="color:green;">ALLOW</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="block2" value="block">
  <label class="form-check-label" for="block2" style="color:red;">BLOCK</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="gray2" value="gray">
  <label class="form-check-label" for="gray2" style="color:gray;">GRAY</label>
</div></td>
<td>
	<input name="data" type="text" class="form-control form-control-sm" id="data" value="">
	<small class="text-muted">'.abTranslate('IPv4 like 2402:9400::c8 or subnet 2402:9400:1000:5::/64').'</small></td>
<td>
      <input name="comment" type="text" class="form-control form-control-sm" id="comment" value="">
      <small class="text-muted">'.abTranslate('Description, so as not to forget why it was created.').'</small>
</td>
<td>
      <input name="expires" type="text" class="form-control form-control-sm" id="expires" value="">
      <small class="text-muted">'.abTranslate('The validity period of the rule (DAYS), then it will be deleted, leave blank for permanent action.').'</small>
</td>
<td><button type="submit" name="newrule_submit" class="btn btn-success btn-sm" title="'.abTranslate('Add').'"><i class="bi bi-plus-square"></i></button></td>
</tr>
</form>
<tr><td colspan="8" class="text-muted">'.abTranslate('Total rules:').' '.$i.'</td></tr></tbody>
</table>
</div>
<br />
';

$content .= '
<div class="table-responsive">
<table class="table table-bordered table-hover table-sm">
<thead class="thead-light">
<tr><th colspan="7"><a name="ab_se_0"></a> '.abTranslate('3) Search by User-Agent part with PTR check (strict chain check: IP ➜ PTR ➜ IP), first of all, these rules are designed to automatically detect search engine bots to add them to the IP allow list. You can also block by partial match in the User-Agent for unnecessary bots (but it\'s better to do this in .htaccess or Nginx).').' <a href="https://antibot.cloud/FAQ.php?page=good-bots&lang='.$lang_code.'" target="_blank" rel="noopener noreferrer">'.abTranslate('List of popular bots and their settings.').'</a></th></tr>
<tr>
<th>priority</th>
<th>rule</th>
<th>user-agent (part)</th>
<th>ptr</th>
<th>comment</th>
<th></th>
</tr>
</thead>
<tbody>
';
$i = 0;
while ($echo = $ab_se_rules->fetchArray(SQLITE3_ASSOC)) {
$i++;
if ($echo['rule'] == 'allow') {$style = 'style="color:green;"';} elseif ($echo['rule'] == 'block') {$style = 'style="color:red;"';} else {$style = 'style="color:gray;"';}
$content .= '<tr>
<td><a name="ab_se_'.$echo['rowid'].'"></a><form action="?'.$abw.$abp.'=priority" method="post" class="form-inline">
<input name="id" type="hidden" value="'.$echo['rowid'].'">
<input name="table" type="hidden" value="ab_se">
<input class="form-control form-control-sm col-md-10" name="priority" type="text" value="'.$echo['priority'].'">
<button type="submit" name="priority_submit" class="btn btn-sm btn-primary col-md-2"><i class="bi bi-arrow-repeat"></i></button>
</form></td>
<td '.$style.'>'.$echo['rule'].'</td>
<td>'.$echo['search'].'</td>
<td>'.$echo['data'].'</td>
<td><small>'.$echo['comment'].'</small></td>
<td><form action="?'.$abw.$abp.'=remove" method="post">
<input name="id" type="hidden" value="'.$echo['rowid'].'">
<input name="table" type="hidden" value="ab_se">
<button type="submit" name="remove_submit" class="btn btn-danger btn-sm" title="'.abTranslate('Remove').'">
<i class="bi bi-trash"></i>
</button>
</form></td>
</tr>';
}
$content .= '
<form action="?'.$abw.$abp.'=newrule" method="post">
<tr>
<td><input type="hidden" name="type" value="ab_se">
<input name="priority" type="text" class="form-control form-control-sm" id="priority" value="100">
<small class="text-muted">'.abTranslate('Priority (order) of checking and applying the rules.').'</small></td>
<td>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="allow3" value="allow" required>
  <label class="form-check-label" for="allow3" style="color:green;">ALLOW</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="block3" value="block">
  <label class="form-check-label" for="block3" style="color:red;">BLOCK</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="gray3" value="gray">
  <label class="form-check-label" for="gray3" style="color:gray;">GRAY</label>
</div></td>
<td>
	<input name="search" type="text" class="form-control form-control-sm" id="search" value="">
	<small class="text-muted">'.abTranslate('Part of the User-Agent for search, for detecting search engine bots.').'</small></td>
<td>
	<input name="data" type="text" class="form-control form-control-sm" id="data" value="">
	<small class="text-muted">'.abTranslate('Allowed PTRs for allow, separated by a space, if you do not check the PTR, then it is empty.').'</small></td>
<td>
      <input name="comment" type="text" class="form-control form-control-sm" id="comment" value="">
      <small class="text-muted">'.abTranslate('Description, so as not to forget why it was created.').'</small>
</td>
<td><button type="submit" name="newrule_submit" class="btn btn-success btn-sm" title="'.abTranslate('Add').'"><i class="bi bi-plus-square"></i></button></td>
</tr>
</form>
<tr><td colspan="6" class="text-muted">'.abTranslate('Total rules:').' '.$i.'</td></tr></tbody>
</table>
</div>
<br />
';

$content .= '
<div class="table-responsive">
<table class="table table-bordered table-hover table-sm">
<thead class="thead-light">
<tr><th colspan="6"><a name="ab_path_0"></a> '.abTranslate('4) Search by part of the URL, first of all, these rules are intended to allow access without checking (allow) to directories and sections.').'</th></tr>
<tr>
<th>priority</th>
<th>rule</th>
<th>url part</th>
<th>comment</th>
<th></th>
</tr>
</thead>
<tbody>
';
$i = 0;
while ($echo = $ab_se_path->fetchArray(SQLITE3_ASSOC)) {
$i++;
if ($echo['rule'] == 'allow') {$style = 'style="color:green;"';} elseif ($echo['rule'] == 'block') {$style = 'style="color:red;"';} else {$style = 'style="color:gray;"';}
$content .= '<tr>
<td><a name="ab_path_'.$echo['rowid'].'"></a><form action="?'.$abw.$abp.'=priority" method="post" class="form-inline">
<input name="id" type="hidden" value="'.$echo['rowid'].'">
<input name="table" type="hidden" value="ab_path">
<input class="form-control form-control-sm col-md-10" name="priority" type="text" value="'.$echo['priority'].'">
<button type="submit" name="priority_submit" class="btn btn-sm btn-primary col-md-2"><i class="bi bi-arrow-repeat"></i></button>
</form></td>
<td '.$style.'>'.$echo['rule'].'</td>
<td>'.$echo['search'].'</td>
<td><small>'.$echo['comment'].'</small></td>
<td><form action="?'.$abw.$abp.'=remove" method="post">
<input name="id" type="hidden" value="'.$echo['rowid'].'">
<input name="table" type="hidden" value="ab_path">
<button type="submit" name="remove_submit" class="btn btn-danger btn-sm" title="'.abTranslate('Remove').'">
<i class="bi bi-trash"></i>
</button>
</form></td>
</tr>';
}
$content .= '
<form action="?'.$abw.$abp.'=newrule" method="post">
<tr>
<td><input type="hidden" name="type" value="ab_path">
<input name="priority" type="text" class="form-control form-control-sm" id="priority" value="100">
<small class="text-muted">'.abTranslate('Priority (order) of checking and applying the rules.').'</small></td>
<td>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="allow4" value="allow" required>
  <label class="form-check-label" for="allow4" style="color:green;">ALLOW</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="block4" value="block">
  <label class="form-check-label" for="block4" style="color:red;">BLOCK</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="gray4" value="gray">
  <label class="form-check-label" for="gray4" style="color:gray;">GRAY</label>
</div></td>
<td>
	<input name="search" type="text" class="form-control form-control-sm" id="search" value="">
	<small class="text-muted">'.abTranslate('Part of the URL to search, for example: /wp-content/uploads/').'</small></td>
<td>
      <input name="comment" type="text" class="form-control form-control-sm" id="comment" value="">
      <small class="text-muted">'.abTranslate('Description, so as not to forget why it was created.').'</small>
</td>
<td><button type="submit" name="newrule_submit" class="btn btn-success btn-sm" title="'.abTranslate('Add').'"><i class="bi bi-plus-square"></i></button></td>
</tr>
</form>
<tr><td colspan="5" class="text-muted">'.abTranslate('Total rules:').' '.$i.'</td></tr></tbody>
</table>
</div>
<br />
';

$content .= '
<div class="table-responsive">
<table class="table table-bordered table-hover table-sm">
<thead class="thead-light">
<tr><th colspan="7"><a name="rules_0"></a> '.abTranslate('5) Base of general rules for various parameters. A visitor who passes by the ALLOW rule receives allowing cookies as having successfully passed the check and will then be displayed in the log with the LOCAL status.').'</th></tr>
<tr>
<th>priority</th>
<th>rule</th>
<th>type</th>
<th>data</th>
<th>comment</th>
<th>expires</th>
<th></th>
</tr>
</thead>
<tbody>
';
$i = 0;
while ($echo = $rules->fetchArray(SQLITE3_ASSOC)) {
$i++;
if ($echo['rule'] == 'allow') {$style = 'style="color:green;"';} elseif ($echo['rule'] == 'block') {$style = 'style="color:red;"';} else {$style = 'style="color:gray;"';}
$content .= '<tr>
<td><a name="rules_'.$echo['rowid'].'"></a><form action="?'.$abw.$abp.'=priority" method="post" class="form-inline">
<input name="id" type="hidden" value="'.$echo['rowid'].'">
<input name="table" type="hidden" value="rules">
<input class="form-control form-control-sm col-md-10" name="priority" type="text" value="'.$echo['priority'].'">
<button type="submit" name="priority_submit" class="btn btn-sm btn-primary col-md-2"><i class="bi bi-arrow-repeat"></i></button>
</form></td>
<td '.$style.'>'.$echo['rule'].'</td>
<td>'.$echo['type'].'</td>
<td>'.$echo['data'].'</td>
<td><small>'.$echo['comment'].'</small></td>
<td><small>'.((is_numeric($echo['expires'])) ? date("Y.m.d H:i:s", $echo['expires']) : '').'</small></td>
<td><form action="?'.$abw.$abp.'=remove" method="post">
<input name="id" type="hidden" value="'.$echo['rowid'].'">
<input name="table" type="hidden" value="rules">
<button type="submit" name="remove_submit" class="btn btn-danger btn-sm" title="'.abTranslate('Remove').'">
<i class="bi bi-trash"></i>
</button>
</form></td>
</tr>';
}
$content .= '
<form action="?'.$abw.$abp.'=newrule" method="post">
<tr>
<td><input name="priority" type="text" class="form-control form-control-sm" id="priority" value="100">
<small class="text-muted">'.abTranslate('Priority (order) of checking and applying the rules.').'</small></td>
<td>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="allow5" value="allow" required>
  <label class="form-check-label" for="allow5" style="color:green;">ALLOW</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="block5" value="block">
  <label class="form-check-label" for="block5" style="color:red;">BLOCK</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="rule" id="gray5" value="gray">
  <label class="form-check-label" for="gray5" style="color:gray;">GRAY</label>
</div></td>
<td>
<select class="form-control form-control-sm" name="type" required>
<option value="">'.abTranslate('Select type').'</option>
<option value="useragent">User-Agent</option>
<option value="country">'.abTranslate('Country').'</option>
<option value="lang">'.abTranslate('Browser language').'</option>
<option value="referer">'.abTranslate('Referrer').'</option>
<option value="ptr">PTR</option>
<option value="asname">AS Name</option>
<option value="asnum">AS Num</option>
<option value="uri">URI</option>
<option value="scriptname">Script Name</option>
<option value="httpaccept">HTTP_ACCEPT</option>
</select> 
<small class="text-muted">'.abTranslate('Description of data types below.').'</small>
</td>
<td>
	<input name="data" type="text" class="form-control form-control-sm" id="data" value="">
	<small class="text-muted">'.abTranslate('The data (user-agent, country, etc.) to be searched can be an empty value.').'</small></td>
<td>
      <input name="comment" type="text" class="form-control form-control-sm" id="comment" value="">
      <small class="text-muted">'.abTranslate('Description, so as not to forget why it was created.').'</small>
</td>
<td>
      <input name="expires" type="text" class="form-control form-control-sm" id="expires" value="">
      <small class="text-muted">'.abTranslate('Rule validity period in days, then it will be deleted, leave blank for permanent effect.').'</small>
</td>
<td><button type="submit" name="newrule_submit" class="btn btn-success btn-sm" title="'.abTranslate('Add').'"><i class="bi bi-plus-square"></i></button></td>
</tr>
</form>
<tr><td colspan="7">
<ul>
<li><strong>User-Agent</strong> ('.abTranslate('search by exact match').') <small class="text-muted">'.abTranslate('Example:').' Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)</small></li>
<li><strong>'.abTranslate('Country').'</strong> ('.abTranslate('2 letter code in upper case. ISO 3166-1 alpha-2 codes:').' <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements" target="_blank" rel="noopener">wiki</a>) <small class="text-muted">'.abTranslate('Example:').' RU '.abTranslate('or').' US</small></li>
<li><strong>'.abTranslate('Browser language').'</strong> ('.abTranslate('2 alphabetic language code in lowercase, ISO 639-1 codes:').' <a href="https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes" target="_blank" rel="noopener">wiki</a>) <small class="text-muted">'.abTranslate('Example:').' ru '.abTranslate('or').' en</small></li>
<li><strong>'.abTranslate('Referrer').'</strong> ('.abTranslate('host only, search by exact match').') <small class="text-muted">'.abTranslate('Example:').' iframe-toloka.com</small></li>
<li><strong>PTR</strong> ('.abTranslate('2nd or 3rd level domains').') <small class="text-muted">'.abTranslate('Example:').' compute.amazonaws.com</small></li>
<li><strong>AS Name</strong> ('.abTranslate('name of the owner of the IP block, taken in the log').') <small class="text-muted">'.abTranslate('Example:').' MICROSOFT CORPORATION</small></li>
<li><strong>AS Num</strong> ('.abTranslate('IP block number, take in the log').') <small class="text-muted">'.abTranslate('Example:').' 8075</small></li>
<li><strong>URI</strong> ('.abTranslate('full page address, from the website root starting with /').') <small class="text-muted">'.abTranslate('Example:').' /page1.html '.abTranslate('or').' /index.php?p=123</small></li>
<li><strong>Script Name</strong> ('.abTranslate('script name from website root starting with / and without get variables').') <small class="text-muted">'.abTranslate('Example:').' /api/send.php</small></li>
<li><strong>HTTP_ACCEPT</strong> ('.abTranslate('search by exact match').') <small class="text-muted">'.abTranslate('Example:').' text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8</small></li>
</ul>
</td></tr>
<tr><td colspan="7" class="text-muted">'.abTranslate('Total rules:').' '.$i.'</td></tr>
</tbody>
</table>
</div>
';
