<?php
// форма редактирования конфига
if(!defined('ANTIBOT')) die('access denied');

$title = abTranslate('Edit conf.php');

if ($ab_config['timezone'] == '' AND date_default_timezone_get() != '') {
$ab_config['timezone'] = date_default_timezone_get();
}

include(__DIR__.'/../data/conf.php');

$content .= '
<form action="?'.$abw.$abp.'=confsave" method="post">
  <div class="form-group row">
    <label for="disable" class="col-sm-2 col-form-label">'.abTranslate('Disable Antibot').'</label>
    <div class="col-sm-10">
  <div class="form-check">
  <input class="form-check-input" type="radio" name="disable" id="disable1" value="1" '.(($ab_config['disable'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="disable1"><span class="text-danger">'.abTranslate('Disable').'</span> <small class="text-muted">('.abTranslate('If you need to temporarily disable without deleting the connection code').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="disable" id="disable0" value="0" '.(($ab_config['disable'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="disable0"><span class="text-success">'.abTranslate('Enable').'</span></label>
</div>
    </div>
  </div>

<hr />

  <div class="form-group row">
    <label for="disable" class="col-sm-2 col-form-label">'.abTranslate('PHP errors').'</label>
    <div class="col-sm-10">
<div class="form-check">
  <input class="form-check-input" type="radio" name="phperror" id="phperror2" value="2" '.(($ab_config['phperror'] == '2') ? 'checked' : '').'>
  <label class="form-check-label" for="phperror2">'.abTranslate('Enable display in the browser, write to the log').' <small class="text-muted">('.abTranslate('For debugging').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="phperror" id="phperror1" value="1" '.(($ab_config['phperror'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="phperror1">'.abTranslate('Disable display in the browser, write to the log').' <small class="text-muted">('.abTranslate('Recommended').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="phperror" id="phperror0" value="0" '.(($ab_config['phperror'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="phperror0">'.abTranslate('Disable display in the browser, disable error log').'</label>
</div>
    </div>
  </div>

<hr />
   
  <div class="form-group row">
    <label for="webdir" class="col-sm-2 col-form-label">'.abTranslate('Web directory').'</label>
    <div class="col-sm-10">
      <input name="webdir" type="text" class="form-control" id="webdir" value="'.$ab_config['webdir'].'">
      <small class="form-text text-muted">'.abTranslate('Antibot web directory, path from website root or with protocol and domain. Example: /antibot8/ or https://yoursite.com/antibot8/').'</small>
    </div>
  </div>

<hr />
   
  <div class="form-group row">
    <label for="timezone" class="col-sm-2 col-form-label">'.abTranslate('Timezone').'</label>
    <div class="col-sm-10">
      <input name="timezone" type="text" class="form-control" id="timezone" value="'.$ab_config['timezone'].'">
      <small class="form-text text-muted"><a href="https://www.php.net/manual/'.$lang_code.'/timezones.php" target="_blank" rel="noopener">'.abTranslate('List of Supported Timezones').'</a></small>
    </div>
  </div>

<hr />
  
  <div class="form-group row">
    <label for="email" class="col-sm-2 col-form-label">'.abTranslate('Email (Login)').'</label>
    <div class="col-sm-10">
      <input name="email" type="text" class="form-control" id="email" value="'.$ab_config['email'].'">
      <small class="form-text text-muted">'.abTranslate('Email registered on the website:').' <a href="https://antibot.cloud/" target="_blank" rel="noopener noreferrer">AntiBot.Cloud.</a></small>
    </div>
  </div>
  
  <div class="form-group row">
    <label for="pass" class="col-sm-2 col-form-label">'.abTranslate('Password').'</label>
    <div class="col-sm-10">
      <input name="pass" type="text" class="form-control" id="pass" value="'.$ab_config['pass'].'">
      <small class="form-text text-muted">'.abTranslate('The password is also from the AntiBot.Cloud website.').'</small>
    </div>
  </div>
<a name="secondpass"></a>
  <div class="form-group row">
    <label for="secondpass" class="col-sm-2 col-form-label">'.abTranslate('Second Password').'</label>
    <div class="col-sm-10">
      <input name="secondpass" type="text" class="form-control" id="secondpass" value="'.(($ab_config['secondpass'] != '') ? '**********' : '').'">
      <small class="form-text text-muted">'.abTranslate('Additional password to enter the admin panel. Not required. If you forget it, clear the <code>secondpass</code> variable in the config.').'</small>
    </div>
  </div>
  
<hr />

  <div class="form-group row">
    <label class="col-sm-2 col-form-label">'.abTranslate('Salt and cookies').'</label>
    <div class="col-sm-10">
      <div class="form-check">
        <input name="newsalt" class="form-check-input" type="checkbox" id="newsalt">
        <label class="form-check-label" for="newsalt">'.abTranslate('Generate new salt').' <small class="text-muted">('.abTranslate('If all visitors need to reset cookies, they will need to pass a new antibot check').').</small></label>
      </div>
<div class="form-check form-check-inline">
  <input class="form-check-input" type="radio" name="timesalt" id="timesalt_Y" value="Y" '.(($ab_config['timesalt'] == 'Y') ? 'checked' : '').'>
  <label class="form-check-label" for="timesalt_Y">'.abTranslate('without resetting cookies').'</label>
</div>
<div class="form-check form-check-inline">
  <input class="form-check-input" type="radio" name="timesalt" id="timesalt_Yz" value="Yz" '.(($ab_config['timesalt'] == 'Yz') ? 'checked' : '').'>
  <label class="form-check-label" for="timesalt_Yz">'.abTranslate('every new day').'</label>
</div>
<div class="form-check form-check-inline">
  <input class="form-check-input" type="radio" name="timesalt" id="timesalt_YW" value="YW" '.(($ab_config['timesalt'] == 'YW') ? 'checked' : '').'>
  <label class="form-check-label" for="timesalt_YW">'.abTranslate('every new week').'</label>
</div>
<small class="form-text text-muted">'.abTranslate('No reset - cookies live for 10 days if the visitor\'s IP and User-Agent do not change.').'</small>
    </div>
  </div>

<hr />

  <div class="form-group row">
    <label for="check_url" class="col-sm-2 col-form-label">'.abTranslate('Check URL').'</label>
    <div class="col-sm-10">
      <input name="check_url" type="text" class="form-control" id="check_url" value="'.$ab_config['check_url'].'">
      <small class="form-text text-muted">'.abTranslate('Leave the field empty for cloud antibot check or enter your local check url, for example the path to:').' '.$ab_config['webdir'].'ab.php</small>
    </div>
  </div>

<hr />

  <div class="form-group row">
    <label for="is_bitrix" class="col-sm-2 col-form-label">'.abTranslate('Is it Bitrix CMS?').'</label>
    <div class="col-sm-10">
  <div class="form-check">
  <input class="form-check-input" type="radio" name="is_bitrix" id="is_bitrix1" value="1" '.(($ab_config['is_bitrix'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="is_bitrix1">'.abTranslate('Website on Bitrix CMS and a looped redirect appears on the check page').'</label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="is_bitrix" id="is_bitrix0" value="0" '.(($ab_config['is_bitrix'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="is_bitrix0">'.abTranslate('There is no specified problem or it is not Bitrix CMS').'</label>
</div>
    </div>
  </div>

<hr />

  <div class="form-group row">
    <label for="timer" class="col-sm-2 col-form-label">'.abTranslate('Timer (sec)').'</label>
    <div class="col-sm-10">
      <input name="timer" type="text" class="form-control" id="timer" value="'.$ab_config['timer'].'">
      <small class="form-text text-muted">'.abTranslate('If the cloud check did not respond in time, then after so many seconds, the login buttons will appear (if they are allowed).').'</small>
    </div>
  </div>

<hr />

  <div class="form-group row">
    <label for="hits_per_user" class="col-sm-2 col-form-label">'.abTranslate('Views').'</label>
    <div class="col-sm-10">
      <input name="hits_per_user" type="text" class="form-control" id="hits_per_user" value="'.$ab_config['hits_per_user'].'">
      <small class="form-text text-muted">'.abTranslate('The number of page views by the visitor on the website, after which to issue a new antibot check.').'</small>
    </div>
  </div>

<hr />

  <div class="form-group row">
    <label for="input_button" class="col-sm-2 col-form-label">'.abTranslate('Login button').'</label>
    <div class="col-sm-10">
  <div class="form-check">
  <input class="form-check-input" type="radio" name="input_button" id="input_button1" value="1" '.(($ab_config['input_button'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="input_button1">'.abTranslate('Disable buttons').' <small class="text-muted">('.abTranslate('If the visitor does not pass the automatic check, he will not get to the website at all.').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="input_button" id="input_button0" value="0" '.(($ab_config['input_button'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="input_button0">'.abTranslate('Do not disable buttons').'</label>
</div>
    </div>
  </div>

  <div class="form-group row">
    <label for="buttons" class="col-sm-2 col-form-label">'.abTranslate('Login button type').'</label>
    <div class="col-sm-10">
  <div class="form-check">
  <input class="form-check-input" type="radio" name="buttons" id="buttons1" value="1" '.(($ab_config['buttons'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="buttons1">'.abTranslate('Multiple buttons with color selection').' <small class="text-muted">('.abTranslate('Выше защита от ботов').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="buttons" id="buttons0" value="0" '.(($ab_config['buttons'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="buttons0">'.abTranslate('One big button "I am human. Continue."').'</label>
</div>
    </div>
  </div>

  <div class="form-group row">
    <label for="time_ban" class="col-sm-2 col-form-label">'.abTranslate('Ban time (hours)').'</label>
    <div class="col-sm-10">
      <input name="time_ban" type="text" class="form-control" id="time_ban" value="'.$ab_config['time_ban'].'">
      <small class="form-text text-muted">'.abTranslate('The number of HOURS for which to ban the IP of those visitors who made a mistake with the color of the button when clicking, if 0 then do not ban.').'</small>
    </div>
  </div>

<hr />
   
  <div class="form-group row">
    <label for="tpl_lang" class="col-sm-2 col-form-label">'.abTranslate('Check page lang').'</label>
    <div class="col-sm-10">
      <input name="tpl_lang" type="text" class="form-control" id="tpl_lang" value="'.$ab_config['tpl_lang'].'">
      <small class="form-text text-muted">'.abTranslate('The language of the texts of the check page (example: ru), if not specified, then the language of the texts = the language of the browser. Languages from the lang/tpl/ directory').'</small>
    </div>
  </div>

<hr />

  <div class="form-group row">
    <label for="re_check" class="col-sm-2 col-form-label">ReCAPTCHA v3</label>
    <div class="col-sm-10">
  <div class="form-check">
  <input class="form-check-input" type="radio" name="re_check" id="re_check1" value="1" '.(($ab_config['re_check'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="re_check1">'.abTranslate('Enable').' <small class="text-muted">('.abTranslate('Invisible receipt of the RE score of the visitor\'s rating, this is not the choice of "boats"').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="re_check" id="re_check0" value="0" '.(($ab_config['re_check'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="re_check0">'.abTranslate('Disable').'</label>
</div>
    </div>
  </div>

  <div class="form-group row">
    <label for="recaptcha_key" class="col-sm-2 col-form-label">'.abTranslate('Public key').'</label>
    <div class="col-sm-10">
      <input name="recaptcha_key" type="text" class="form-control" id="recaptcha_key" value="'.$ab_config['recaptcha_key'].'">
      <small class="form-text text-muted">'.abTranslate('Public reCAPTCHA v3 website key.').' <a href="https://www.google.com/recaptcha/admin/create" target="_blank" rel="noopener">'.abTranslate('Create keys for free.').'</a></small>
    </div>
  </div>

  <div class="form-group row">
    <label for="recaptcha_secret" class="col-sm-2 col-form-label">'.abTranslate('Private key').'</label>
    <div class="col-sm-10">
      <input name="recaptcha_secret" type="text" class="form-control" id="recaptcha_secret" value="'.$ab_config['recaptcha_secret'].'">
      <small class="form-text text-muted">'.abTranslate('Private reCAPTCHA v3 website key.').'</small>
    </div>
  </div>

<hr />

  <div class="form-group row">
    <label for="utm_referrer" class="col-sm-2 col-form-label">UTM Referrer</label>
    <div class="col-sm-10">
  <div class="form-check">
  <input class="form-check-input" type="radio" name="utm_referrer" id="utm_referrer1" value="1" '.(($ab_config['utm_referrer'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="utm_referrer1">'.abTranslate('Enable').' <small class="text-muted">('.abTranslate('To pass a referrer to Yandex.Metrica by substituting an additional GET variable in the URL').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="utm_referrer" id="utm_referrer0" value="0" '.(($ab_config['utm_referrer'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="utm_referrer0">'.abTranslate('Disable').'</label>
</div>
    </div>
  </div>

  <div class="form-group row">
    <label for="utm_noindex" class="col-sm-2 col-form-label">'.abTranslate('UTM indexing').'</label>
    <div class="col-sm-10">
  <div class="form-check">
  <input class="form-check-input" type="radio" name="utm_noindex" id="utm_noindex1" value="1" '.(($ab_config['utm_noindex'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="utm_noindex1">'.abTranslate('Disable indexing').' <small class="text-muted">('.abTranslate('URLs with utm_referrer added will not be indexed by search engines').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="utm_noindex" id="utm_noindex0" value="0" '.(($ab_config['utm_noindex'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="utm_noindex0">'.abTranslate('Do not prohibit').' <small class="text-muted">('.abTranslate('If the website has a rel="canonical" meta tag, then it will solve the problem of duplicates').').</small></label>
</div>
    </div>
  </div>
  
<hr />

  <div class="form-group row">
    <label for="check_get_ref" class="col-sm-2 col-form-label">'.abTranslate('GET referrer').'</label>
    <div class="col-sm-10">
  <div class="form-check">
  <input class="form-check-input" type="radio" name="check_get_ref" id="check_get_ref1" value="1" '.(($ab_config['check_get_ref'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="check_get_ref1">'.abTranslate('Check').' <small class="text-muted">('.abTranslate('Check GET variable names in REFERRER URL against stop list').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="check_get_ref" id="check_get_ref0" value="0" '.(($ab_config['check_get_ref'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="check_get_ref0">'.abTranslate('Do not check').'</label>
</div>
    </div>
  </div>

  <div class="form-group row">
    <label for="bad_get_ref" class="col-sm-2 col-form-label">'.abTranslate('Stop name list').'</label>
    <div class="col-sm-10">
      <input name="bad_get_ref" type="text" class="form-control" id="bad_get_ref" value="'.$ab_config['bad_get_ref'].'">
      <small class="form-text text-muted">'.abTranslate('If in the referrer there are (with any content or empty) these get variables, then they will not automatically start up, you will have to press the buttons. Protection against refspam with fake search queries. Specify with a space.').'</small>
    </div>
  </div>

<hr />

  <div class="form-group row">
    <label for="secret_allow_get" class="col-sm-2 col-form-label">Secret allow get</label>
    <div class="col-sm-10">
      <input name="secret_allow_get" type="text" class="form-control" id="secret_allow_get" value="'.$ab_config['secret_allow_get'].'">
      <small class="form-text text-muted">'.abTranslate('The name of the secret GET variable, if it is in the URL, means to let this visitor go without checking (the antibot will not be connected, these visits will not be added to the logs), a cookie with this name is also set, if these cookies are present, the antibot will also not connect. This is necessary in cases where you are doing behavioral cheats on your website so as not to interfere with your bots.').'</small>
    </div>
  </div>

<hr />

<div class="form-group row">
 <label for="antibot_log_tests" class="col-sm-2 col-form-label">Main Logs</label>
    <div class="col-sm-10">
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_tests" id="antibot_log_tests1" value="1" '.(($ab_config['antibot_log_tests'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_tests1">'.abTranslate('Enable').' <small class="text-muted">('.abTranslate('The main log of those who got to the check page, saves entries in the log with statuses: STOP, AUTO, POST').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_tests" id="antibot_log_tests0" value="0" '.(($ab_config['antibot_log_tests'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_tests0">'.abTranslate('Disable').'</label>
</div>
    </div>
</div>

<div class="form-group row">
 <label for="antibot_log_local" class="col-sm-2 col-form-label">LOCAL Log</label>
    <div class="col-sm-10">
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_local" id="antibot_log_local1" value="1" '.(($ab_config['antibot_log_local'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_local1">'.abTranslate('Enable').' <small class="text-muted">('.abTranslate('Log of successfully passed antibot checks and having permission cookies').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_local" id="antibot_log_local0" value="0" '.(($ab_config['antibot_log_local'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_local0">'.abTranslate('Disable').' <small class="text-muted">('.abTranslate('Recommended').').</small></label>
</div>
    </div>
</div>

<div class="form-group row">
 <label for="antibot_log_allow" class="col-sm-2 col-form-label">ALLOW Log</label>
    <div class="col-sm-10">
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_allow" id="antibot_log_allow1" value="1" '.(($ab_config['antibot_log_allow'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_allow1">'.abTranslate('Enable').' <small class="text-muted">('.abTranslate('Log of those who passed without checking according to allowing rules').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_allow" id="antibot_log_allow0" value="0" '.(($ab_config['antibot_log_allow'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_allow0">'.abTranslate('Disable').'</label>
</div>
    </div>
</div>

<div class="form-group row">
 <label for="antibot_log_fake" class="col-sm-2 col-form-label">FAKE Log</label>
    <div class="col-sm-10">
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_fake" id="antibot_log_fake1" value="1" '.(($ab_config['antibot_log_fake'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_fake1">'.abTranslate('Enable').' <small class="text-muted">('.abTranslate('Log of unverified IP➜PTR➜IP, fake bots masquerading as search engines').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_fake" id="antibot_log_fake0" value="0" '.(($ab_config['antibot_log_fake'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_fake0">'.abTranslate('Disable').'</label>
</div>
    </div>
</div>

<div class="form-group row">
 <label for="antibot_log_goodip" class="col-sm-2 col-form-label">GOODIP Log</label>
    <div class="col-sm-10">
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_goodip" id="antibot_log_goodip1" value="1" '.(($ab_config['antibot_log_goodip'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_goodip1">'.abTranslate('Enable').' <small class="text-muted">('.abTranslate('Request log with IP from the allowed list, search engine bots').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_goodip" id="antibot_log_goodip0" value="0" '.(($ab_config['antibot_log_goodip'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_goodip0">'.abTranslate('Disable').' <small class="text-muted">('.abTranslate('Recommended because can cause increased load on the server').').</small></label>
</div>
    </div>
</div>

<div class="form-group row">
 <label for="antibot_log_block" class="col-sm-2 col-form-label">BLOCK Log</label>
    <div class="col-sm-10">
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_block" id="antibot_log_block1" value="1" '.(($ab_config['antibot_log_block'] == '1') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_block1">'.abTranslate('Enable').' <small class="text-muted">('.abTranslate('Log blocked by blocking rules').').</small></label>
</div>
<div class="form-check">
  <input class="form-check-input" type="radio" name="antibot_log_block" id="antibot_log_block0" value="0" '.(($ab_config['antibot_log_block'] == '0') ? 'checked' : '').'>
  <label class="form-check-label" for="antibot_log_block0">'.abTranslate('Disable').'</label>
</div>
    </div>
</div>

<hr />

  <div class="form-group row">
    <label for="header_test_code" class="col-sm-2 col-form-label">Header Check Page</label>
    <div class="col-sm-10">
      <input name="header_test_code" type="text" class="form-control" id="header_test_code" value="'.$ab_config['header_test_code'].'">
      <small class="form-text text-muted">'.abTranslate('The server response code for the check page. Options:').' 200, 400, 401, 403, 404, 410, 451, 500, 502, 503, 504, 511. <a href="https://en.wikipedia.org/wiki/List_of_HTTP_status_codes" target="_blank" rel="noopener">Wiki: List of HTTP status</a>.</small>
    </div>
  </div>

  <div class="form-group row">
    <label for="header_error_code" class="col-sm-2 col-form-label">Header Block Page</label>
    <div class="col-sm-10">
      <input name="header_error_code" type="text" class="form-control" id="header_error_code" value="'.$ab_config['header_error_code'].'">
      <small class="form-text text-muted">'.abTranslate('Server response code for the blocking page. Options:').' 200, 400, 401, 403, 404, 410, 451, 500, 502, 503, 504, 511. <a href="https://en.wikipedia.org/wiki/List_of_HTTP_status_codes" target="_blank" rel="noopener">Wiki: List of HTTP status</a>.</small>
    </div>
  </div>

<hr />

  <div class="form-group row">
    <label class="col-sm-2 col-form-label">'.abTranslate('Log storage period').'</label>
    <div class="col-sm-10">
  <a name="cron"></a>
<div class="form-check form-check-inline">
  <input class="form-check-input" type="radio" name="period_cleaning" id="period_cleaning_lastday" value="lastday" '.(($ab_config['period_cleaning'] == 'lastday') ? 'checked' : '').'>
  <label class="form-check-label" for="period_cleaning_lastday">'.abTranslate('Last Day').'</label>
</div>
<div class="form-check form-check-inline">
  <input class="form-check-input" type="radio" name="period_cleaning" id="period_cleaning_lastweek" value="lastweek" '.(($ab_config['period_cleaning'] == 'lastweek') ? 'checked' : '').'>
  <label class="form-check-label" for="period_cleaning_lastweek">'.abTranslate('Last Week').'</label>
</div>
<div class="form-check form-check-inline">
  <input class="form-check-input" type="radio" name="period_cleaning" id="period_cleaning_lastmonth" value="lastmonth" '.(($ab_config['period_cleaning'] == 'lastmonth') ? 'checked' : '').'>
  <label class="form-check-label" for="period_cleaning_lastmonth">'.abTranslate('Last Month').'</label>
</div>
<div class="form-check form-check-inline">
  <input class="form-check-input" type="radio" name="period_cleaning" id="period_cleaning_lastyear" value="lastyear" '.(($ab_config['period_cleaning'] == 'lastyear') ? 'checked' : '').'>
  <label class="form-check-label" for="period_cleaning_lastyear">'.abTranslate('Last Year').'</label>
</div>
<div class="form-check form-check-inline">
  <input class="form-check-input" type="radio" name="period_cleaning" id="period_cleaning_all" value="all" '.(($ab_config['period_cleaning'] == 'all') ? 'checked' : '').'>
  <label class="form-check-label" for="period_cleaning_all">'.abTranslate('All time').'</label>
</div>
<small class="form-text text-muted">'.abTranslate('Delete for this period.').' '.abTranslate('Set up a CRON job to automatically remove old entries from the Query Log:').'<br />
<code>0 1 * * * /usr/bin/php -q '.dirname(dirname(__FILE__)).'/code/clear_old_hits.php > /dev/null 2>&1</code>
<br />'.abTranslate('Check with your hosting provider on how to run a php script in a crontab.').'
</small>
    </div>
  </div>

<hr />
  <div class="form-group row">
    <div class="col-sm-10">
      <button name="save_conf" type="submit" class="btn btn-primary">'.abTranslate('Save Settings').'</button>
    </div>
  </div>
</form>
';
